/*

BSD License

Copyright (c) 2002, Brent Simmons
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

*	Redistributions of source code must retain the above copyright notice,
	this list of conditions and the following disclaimer.
*	Redistributions in binary form must reproduce the above copyright notice,
	this list of conditions and the following disclaimer in the documentation
	and/or other materials provided with the distribution.
*	Neither the name of ranchero.com or Brent Simmons nor the names of its
	contributors may be used to endorse or promote products derived
	from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

/*
	HotKeyPrefs.m
	Huevos

	Created by Brent Simmons on Thu Oct 24 2002.
	Copyright (c) 2002 Ranchero Software. All rights reserved.
*/


#import "HotKeyPrefs.h"


@implementation HotKeyPrefs


+ (void) sendHotKeyChangedNotification {
	
	/*
	Notify the world that the hot key prefs changed.
	*/
	
	[[NSNotificationCenter defaultCenter]
		postNotificationName: @"HotKeyChanged" object: nil];
	} /*sendHotKeyChangedNotification*/
	
	
+ (int) hotKeyModifier {
	
	return [[[NSUserDefaults standardUserDefaults]
		objectForKey: hotKeyModifierPrefsKey] intValue];
	} /*hotKeyModifier*/


+ (void) setHotKeyModifier: (int) val {
	
	if (val == [self hotKeyModifier])
		return; /*nothing to do*/
		
	[[NSUserDefaults standardUserDefaults]
		setObject: [NSNumber numberWithInt: val]
		forKey: hotKeyModifierPrefsKey];
		
	[self sendHotKeyChangedNotification];
	} /*setHotKeyModifier*/
	

+ (int) hotKey {
	
	return [[[NSUserDefaults standardUserDefaults]
		objectForKey: hotKeyPrefsKey] intValue];	
	} /*hotKey*/
	

+ (void) setHotKey: (int) val {
	
	if (val == [self hotKey])
		return; /*nothing to do*/
		
	[[NSUserDefaults standardUserDefaults]
		setObject: [NSNumber numberWithInt: val]
		forKey: hotKeyPrefsKey];

	[self sendHotKeyChangedNotification];
	} /*setHotKey*/
	

@end
